﻿import "../styles/globals.css";

export const metadata = {
  title: "NILTO クイックスタート サンプルサイト",
  description: "NILTO CMS の記事を表示するサンプルサイト",
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="ja">
      <body>
        <header className="site-header">
          <div className="container">
            <a className="site-title" href="/">
              NILTO Sample Site
            </a>
          </div>
        </header>
        <main className="main">
          <div className="container">{children}</div>
        </main>
      </body>
    </html>
  );
}

