﻿import {
  fetchArticles,
  formatDate,
  getCategoryLabel,
  getImageUrlOrPlaceholder,
} from "@/lib/nilto";

export default async function Home() {
  let articles = [];
  let errorMessage = "";

  try {
    articles = await fetchArticles();
  } catch (error) {
    errorMessage = error instanceof Error ? error.message : "不明なエラーです";
  }

  return (
    <>
      <h1 className="section-title">最新記事</h1>
      {errorMessage ? (
        <div className="error-box">{errorMessage}</div>
      ) : articles.length === 0 ? (
        <p>記事がありません。</p>
      ) : (
        <div className="card-grid">
          {articles.map((article) => {
            const imageUrl = getImageUrlOrPlaceholder(article.image);
            const category = getCategoryLabel(article.category);
            const publishedAt = formatDate(
              article._published_at || article._created_at
            );

            return (
              <a className="card" href={`/articles/${article._id}`} key={article._id}>
                <img src={imageUrl} alt={article.title || "No image"} loading="lazy" />
                <div className="card-meta">
                  {category && <span>{category}</span>}
                  {article.author?.name && <span>{article.author.name}</span>}
                  {publishedAt && <span>{publishedAt}</span>}
                </div>
                <h2 className="card-title">{article.title || "無題の記事"}</h2>
              </a>
            );
          })}
        </div>
      )}
    </>
  );
}
